package gov.va.vinci.dart.json;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "comment", propOrder = {
	    "activityId",
	    "requestId",
	    "commentId",
	    "parentId",
	    "author",
	    "commentStatus",
	    "commentText",
	    "created",
	    "description",
	    "shortText",
	    "replies",
	    "parents"
	})
public class CommentView {
	
	@XmlElement(name="reply")
//	private List<CommentReplyView> replies = new ArrayList<CommentReplyView>();
	private List<CommentView> replies = new ArrayList<CommentView>();
	
	@XmlElement(name="parents")
	private List<Integer> parents = new ArrayList<Integer>();	//used by the UI (indentation and show/hide)
	
	private int activityId;
	private int requestId;
	private int commentId;
	private int parentId;
	private String author;
	private String commentStatus;
	private String commentText;
	private String created;
	private String description;
	private String shortText;

	public int getActivityId() {
		return activityId;
	}

	public void setActivityId(int activityId) {
		this.activityId = activityId;
	}

	public int getRequestId() {
		return requestId;
	}

	public void setRequestId(int requestId) {
		this.requestId = requestId;
	}	
	
	public int getCommentId() {
		return commentId;
	}

	public void setCommentId(int commentId) {
		this.commentId = commentId;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public String getCommentStatus() {
		return commentStatus;
	}

	public void setCommentStatus(String commentStatus) {
		this.commentStatus = commentStatus;
	}

	public String getCommentText() {
		return commentText;
	}

	public void setCommentText(String commentText) {
		this.commentText = commentText;
	}

	public String getCreated() {
		return created;
	}

	public void setCreated(String created) {
		this.created = created;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getShortText() {
		return shortText;
	}

	public void setShortText(String shortText) {
		this.shortText = shortText;
	}

	public int getParentId() {
		return parentId;
	}

	public void setParentId(int parentId) {
		this.parentId = parentId;
	}
	
//	public List<CommentReplyView> getReplies() {
//		return replies;
//	}

	public List<CommentView> getReplies() {
		return replies;
	}

	public List<Integer> getParents() {
		return parents;
	}
}
